require( "scripts/style.lua" );
require( "scripts/chocshopstyle.lua" );
require( "scripts/transitions.lua" );

kButtonSpacing = 70;
kButtonY = kCenter - 140;
xOffset = -3;

function LaunchWorldMap()
    SwapToModal( "scripts/worldmap.lua" );
end

MakeDialog
{
	name = "pause",
	
	KSplit9Image
	{
	    image	= "ui/backgrounds/split9_dialog_small",	
		x		= kCenter,
		y		= kCenter,
		w		= 180,
		h		= 385,
		x1		= 40,
		y1		= 40,
		x2		= 40,
		y2		= 40,
		
		SetStyle( CSOvalLightBlueButtonStyle );
		
		-------------------------------------- Resume
		Button
		{
			x		= kCenter + xOffset,
			y		= kButtonY + (kButtonSpacing * 0),
			label	= "pause_resume",
			command	= 
				function()
					InsideGame( true );
                    PauseSounds(false, kSFXSoundGroup);
					PopModal( "pause" );
				end
		},
		
		SetStyle( CSOvalLightBlueButtonStyle );
		-------------------------------------- Map
		Button
		{
			x		= kCenter + xOffset,
			y		= kButtonY + (kButtonSpacing * 1),
			label	= "options_map",
			command	= 
				function()
				    SetQuitting(true);
				    if(GetCurrentGameMode() == 0) then
		                result = DisplayDialog{ "scripts/yesno.lua", body = "quit_level_body", header = "", width=390, height=280 };
		            else
		                result = DisplayDialog{ "scripts/yesno.lua", body = "quit_endless_body", header = "", width=390, height=280 };
		            end
				    if( result == "yes" ) then
				        DoMetrics(2, false);
					    PostMessage( CreateNamedMessage( kBounceBack, "PostMessage( CreateNamedMessage( kFadeToBlack, 'LaunchWorldMap();' ) );" ) ); 
					end
		            SetQuitting(false);
				end
		},
		
		SetStyle( CSOvalLightBlueButtonStyle );
		-------------------------------------- Options
		Button
		{
			x		= kCenter + xOffset,
			y		= kButtonY + (kButtonSpacing * 2),
			label	= "pause_options",
			command	=
				function()
					DoModal( "scripts/options.lua" );
				end
		},
		
		SetStyle( CSOvalLightBlueButtonStyle );
		-------------------------------------- Restart
		Button
		{
			x		= kCenter + xOffset,
			y		= kButtonY + (kButtonSpacing * 3),
			label	= "pause_restart",
			command	=
				function()
				    SetQuitting(true);
				    if(GetCurrentGameMode() == 0) then
		                result = DisplayDialog{ "scripts/yesno.lua", body = "restart_body", header = "", width=410, height=280 };
		            else
		                result = DisplayDialog{ "scripts/yesno.lua", body = "restart_endless_body", header = "", width=390, height=280 };
		            end
					if( result == 'yes' ) then
				        DoMetrics(2, false);
					    CloseWindow();
						PostMessage( CreateNamedMessage( kFadeToBlack, "DisplayDialog { 'scripts/loading.lua', isFirst = false };" ) );
					end
				    SetQuitting(false);
				end
		},
		
		SetStyle( CSOvalLightBlueButtonStyle );
		-------------------------------------- Quit
		Button
		{
			x		= kCenter + xOffset,
			y		= kButtonY + (kButtonSpacing * 4),
			sound	= kDefaultButtonSoundOut,
			label	= "pause_quit",		
			command	=
				function()
				    SetQuitting(true);
					if(GetCurrentGameMode() == 0) then
		                result = DisplayDialog{ "scripts/yesno.lua", body = "quit_game_body", header = "", width=390, height=280 };
		            else
		                result = DisplayDialog{ "scripts/yesno.lua", body = "quit_endless_body", header = "", width=390, height=280 };
		            end
					if( result == 'yes' ) then
				        DoMetrics(2, false);
						PostMessage( CreateNamedMessage( kFadeToBlack, "QuitToMainMenu();" ) );
					end
				    SetQuitting(false);
				end
		},
		
		--[[SetStyle( CSOvalDarkBlueButtonStyle );
		-------------------------------------- Sweet Rewards
		Button
		{
			x		= kCenter + xOffset,
			y		= kButtonY + (kButtonSpacing * 5),
			sound	= kDefaultButtonSoundOut,
			label	= "map_sweetrewards",
			command	=
				function()
					PostMessage( CreateNamedMessage( kFadeToBlack, "DisplayDialog{ 'scripts/rewardswindow.lua', context='game' };" ) );
				end
		},]]
	},
}

InsideGame( false );
PauseSounds(true, kSFXSoundGroup);